#!/bin/bash

# Usage: ./manage-charts.sh [install|upgrade|uninstall] <namespace>

ACTION=$1
NAMESPACE=$2

if [[ -z "$ACTION" || -z "$NAMESPACE" ]]; then
  echo "Usage: $0 [install|upgrade|uninstall] <namespace>"
  exit 1
fi

CHARTS=(
  "announcement:announcement"
  "assignment:assignment"
  "auth:auth"
  "chat:chat"
  "course:course"
  "email:email"
  "fileupload:fileupload"
  "gateway:gateway"
  "landingpage:landingpage"
  "lookup:lookup"
  "notification:notification"
  "admin:admin"
  "portal:portal"
  "publicsecurity:publicsecurity"
  "quiz:quiz"
  "report:report"
  "log:log"
  "sms:sms"
  "tvs:tvs"
)

for entry in "${CHARTS[@]}"; do
  RELEASE="${entry%%:*}"
  CHART_DIR="${entry##*:}"
  VALUES="./$CHART_DIR/values.yaml"

  case $ACTION in
    install)
      echo "Installing $RELEASE..."
      helm install "$RELEASE" "./$CHART_DIR" --namespace "$NAMESPACE" --create-namespace -f "$VALUES"
      ;;
    upgrade)
      echo "Upgrading $RELEASE..."
      helm upgrade --install --force "$RELEASE" "./$CHART_DIR" --namespace "$NAMESPACE" -f "$VALUES"
      ;;
    uninstall)
      echo "Uninstalling $RELEASE..."
      helm uninstall "$RELEASE" --namespace "$NAMESPACE"
      ;;
    *)
      echo "Invalid action: $ACTION. Use install, upgrade, or uninstall."
      exit 1
      ;;
  esac
done
